/*
 * Decompiled with CFR 0.152.
 */
package Entity;

import Entity.GameObject;
import Handlers.Content;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class Explosion
extends GameObject {
    private boolean remove;
    private BufferedImage[] sprites;
    private int i;
    private int type;
    public static final int MISSILE = 0;
    public static final int SHIP = 1;

    public Explosion(int type) {
        this.type = type;
        this.dx = 0.0;
        if (type == 0) {
            this.width = 256;
            this.height = 256;
            this.cwidth = 8;
            this.cheight = 8;
            this.sprites = Content.MissileExplosion;
            this.animation.setDelay(10L);
        } else if (type == 1) {
            this.width = 110;
            this.height = 102;
            this.cwidth = 0;
            this.cheight = 0;
            this.sprites = Content.ShipExplosion;
            this.animation.setDelay(150L);
        }
        this.animation.setFrames(this.sprites);
    }

    public boolean shouldRemove() {
        return this.remove;
    }

    public void update() {
        if (this.type == 0) {
            if (this.i < 17) {
                this.cwidth += this.i;
                this.cheight += this.i;
                this.x -= 4.0;
                this.y -= 1.0;
            }
            if (this.i > 32) {
                this.cwidth -= this.i;
                this.cheight -= this.i;
            }
            ++this.i;
        }
        this.checkTileMapCollision();
        this.animation.update();
        if (this.animation.hasPlayedOnce()) {
            this.cwidth = 0;
            this.cheight = 0;
            this.remove = true;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.type == 0) {
            this.setTweakx(-70);
            this.setTweaky(-70);
        } else if (this.type == 1) {
            this.tweakx = -38;
            this.tweaky = -38;
        }
        super.draw(g);
    }
}

